const mongoose = require("mongoose");

const couponSchema = new mongoose.Schema(
  {
    code: {
      type: String,
      required: [true, "Coupon code is required"],
      unique: true,
      uppercase: true,
      trim: true,
    },
    discount: {
      type: Number,
      required: [true, "Discount percentage is required"],
      min: 1,
      max: 100,
    },
    mode: {
      type: String,
      enum: ["manual", "automatic"],
      default: "manual",
    },
    // ✅ NEW FIELD: Campus Restriction
    campus: {
      type: mongoose.Schema.ObjectId,
      ref: "Campus",
      default: null, // null implies "All Campuses"
    },
    expiresAt: {
      type: Date,
      required: [true, "Coupon must have an expiration date"],
    },
    maxUses: {
      type: Number,
      default: 100,
    },
    usedCount: {
      type: Number,
      default: 0,
    },
    isActive: {
      type: Boolean,
      default: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Coupon", couponSchema);
